<?php
include __DIR__ . "/../config.php"; 

$admin_id = $_GET['admin_id'] ?? 0;
if (!in_array($admin_id, $admins)) {
  die('Access Denied. You must be an admin to access this page.');
}

// دریافت مقادیر فعلی از فایل CSS
function get_current_theme_vars() {
  $css_content = file_get_contents(__DIR__ . '/theme.css');
  $vars = [];
  // استخراج تمام متغیرهای CSS
  preg_match_all('/(--[a-zA-Z0-9_-]+)\s*:\s*([^;]+);/m', $css_content, $matches, PREG_SET_ORDER);
  
  foreach ($matches as $match) {
    $vars[trim($match[1])] = trim($match[2]);
  }
  return json_encode($vars);
}
?>
<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>مدیریت پوسته مدرن</title>
  <style>
    :root {
      --sidebar-width: 350px;
      --primary: #007AFF;
      --bg: #f0f2f5;
    }
    body { font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, Helvetica, Arial, sans-serif; display: flex; height: 100vh; margin: 0; overflow: hidden; background: var(--bg); direction: rtl; }
    
    /* سایدبار تنظیمات */
    .sidebar { width: var(--sidebar-width); background: #fff; border-left: 1px solid #ddd; display: flex; flex-direction: column; z-index: 10; box-shadow: -5px 0 15px rgba(0,0,0,0.03); }
    .sidebar-header { padding: 20px; border-bottom: 1px solid #eee; display: flex; align-items: center; justify-content: space-between; background: #fff; }
    .sidebar-header h2 { margin: 0; font-size: 16px; font-weight: 700; color: #333; }
    .badge { background: var(--primary); color: #fff; font-size: 10px; padding: 3px 8px; border-radius: 10px; }
    
    .sidebar-content { flex-grow: 1; overflow-y: auto; padding: 15px; }
    
    /* گروه‌بندی تنظیمات */
    .section-title { font-size: 12px; color: #888; font-weight: 700; text-transform: uppercase; margin: 25px 0 10px 0; display: flex; align-items: center; gap: 8px; border-bottom: 1px solid #f0f0f0; padding-bottom: 5px; }
    .section-title:first-of-type { margin-top: 0; }
    .section-title svg { width: 14px; height: 14px; fill: #888; }

    .control-group { margin-bottom: 12px; background: #fff; border: 1px solid #e1e4e8; border-radius: 8px; padding: 8px 12px; display: flex; align-items: center; justify-content: space-between; transition: border-color 0.2s; }
    .control-group:hover { border-color: #bbb; }
    .control-label { font-size: 13px; color: #444; font-weight: 500; }
    .control-input { display: flex; align-items: center; gap: 8px; }

    /* استایل ورودی‌ها */
    input[type="color"] { width: 32px; height: 32px; border: none; background: none; padding: 0; cursor: pointer; -webkit-appearance: none; }
    input[type="color"]::-webkit-color-swatch-wrapper { padding: 0; }
    input[type="color"]::-webkit-color-swatch { border: 1px solid rgba(0,0,0,0.1); border-radius: 8px; }
    
    input[type="text"] { width: 70px; border: 1px solid #ddd; border-radius: 6px; padding: 4px 8px; font-size: 12px; text-align: center; direction: ltr; color: #555; }
    input[type="text"]:focus { border-color: var(--primary); outline: none; }
    
    input[type="range"] { width: 80px; }

    /* فوتر دکمه‌ها */
    .sidebar-footer { padding: 15px; border-top: 1px solid #eee; background: #fff; display: flex; gap: 10px; }
    .btn { flex: 1; padding: 12px; border: none; border-radius: 10px; font-size: 14px; font-weight: 600; cursor: pointer; transition: 0.2s; }
    .btn-save { background: var(--primary); color: #fff; flex: 2; }
    .btn-save:hover { background: #0062cc; }
    .btn-save:disabled { background: #ccc; cursor: wait; }
    .btn-reset { background: #f5f5f7; color: #ff3b30; border: 1px solid #e5e5ea; }
    .btn-reset:hover { background: #ffe5e5; border-color: #ffb3b3; }

    /* بخش پیش‌نمایش */
    .preview-area { flex-grow: 1; display: flex; flex-direction: column; align-items: center; justify-content: center; position: relative; background-image: radial-gradient(#dfe3e8 1px, transparent 1px); background-size: 20px 20px; }
    
    .device-mockup { width: 375px; height: 812px; background: #000; border-radius: 40px; padding: 10px; box-shadow: 0 25px 50px -12px rgba(0, 0, 0, 0.25); position: relative; border: 4px solid #333; }
    .device-notch { position: absolute; top: 0; left: 50%; transform: translateX(-50%); width: 150px; height: 24px; background: #000; border-bottom-left-radius: 16px; border-bottom-right-radius: 16px; z-index: 2; }
    iframe { width: 100%; height: 100%; border: none; border-radius: 32px; background: #fff; }

    /* تست نوتیفیکیشن */
    .toast { position: absolute; top: 30px; left: 50%; transform: translateX(-50%) translateY(-20px); background: #333; color: #fff; padding: 10px 20px; border-radius: 30px; font-size: 13px; opacity: 0; visibility: hidden; transition: 0.3s; z-index: 100; box-shadow: 0 5px 15px rgba(0,0,0,0.2); display: flex; align-items: center; gap: 8px; }
    .toast.show { opacity: 1; visibility: visible; transform: translateX(-50%) translateY(0); }
    .toast.success { background: #10b981; }
    .toast.error { background: #ef4444; }
  </style>
</head>
<body>

  <div class="sidebar">
    <div class="sidebar-header">
      <h2>تنظیمات پوسته</h2>
      <span class="badge">v2.0</span>
    </div>
    
    <div class="sidebar-content">
      
      <div class="section-title">
        <svg viewBox="0 0 24 24"><path d="M12 22C6.49 22 2 17.51 2 12S6.49 2 12 2s10 4.49 10 10-4.49 10-10 10zm0-18c-4.41 0-8 3.59-8 8s3.59 8 8 8 8-3.59 8-8-3.59-8-8-8z"/></svg>
        رنگ‌های اصلی و وضعیت
      </div>
      
      <div class="control-group">
        <span class="control-label">رنگ اصلی (Primary)</span>
        <div class="control-input">
          <input type="text" id="hex-primary" readonly>
          <input type="color" id="--primary-color" data-var="--primary-color" data-rgb="--primary-color-rgb">
        </div>
      </div>
      
      <div class="control-group">
        <span class="control-label">موفقیت (Positive)</span>
        <div class="control-input">
           <input type="color" id="--positive-color" data-var="--positive-color">
        </div>
      </div>
      
      <div class="control-group">
        <span class="control-label">خطا (Negative)</span>
        <div class="control-input">
           <input type="color" id="--negative-color" data-var="--negative-color">
        </div>
      </div>

      <div class="section-title">
        <svg viewBox="0 0 24 24"><path d="M20 4H4c-1.1 0-2 .9-2 2v12c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V6c0-1.1-.9-2-2-2zm0 4l-8 5-8-5V6l8 5 8-5v2z"/></svg>
        باکس دعوت اختصاصی
      </div>
      
      <div class="control-group">
        <span class="control-label">رنگ پس‌زمینه</span>
        <div class="control-input">
          <input type="color" id="--invite-card-bg" data-var="--invite-card-bg">
        </div>
      </div>
      <div class="control-group">
        <span class="control-label">رنگ متن</span>
        <div class="control-input">
          <input type="color" id="--invite-text-color" data-var="--invite-text-color">
        </div>
      </div>
      <div class="control-group">
        <span class="control-label">رنگ سایه (Shadow)</span>
        <div class="control-input">
           <input type="text" id="--invite-shadow-color" data-var="--invite-shadow-color" placeholder="rgba(...)">
        </div>
      </div>

      <div class="section-title">
        <svg viewBox="0 0 24 24"><path d="M12 7c-2.76 0-5 2.24-5 5s2.24 5 5 5 5-2.24 5-5-2.24-5-5-5zM2 13h2c.55 0 1-.45 1-1s-.45-1-1-1H2c-.55 0-1 .45-1 1s.45 1 1 1zm18 0h2c.55 0 1-.45 1-1s-.45-1-1-1h-2c-.55 0-1 .45-1 1s.45 1 1 1zM11 2v2c0 .55.45 1 1 1s1-.45 1-1V2c0-.55-.45-1-1-1s-1 .45-1 1zm0 18v2c0 .55.45 1 1 1s1-.45 1-1v-2c0-.55-.45-1-1-1s-1 .45-1 1zM5.99 4.58c-.39-.39-1.03-.39-1.41 0-.39.39-.39 1.03 0 1.41l1.06 1.06c.39.39 1.03.39 1.41 0s.39-1.03 0-1.41L5.99 4.58zm12.37 12.37c-.39-.39-1.03-.39-1.41 0-.39.39-.39 1.03 0 1.41l1.06 1.06c.39.39 1.03.39 1.41 0 .39-.39.39-1.03 0-1.41l-1.06-1.06zm1.06-10.96c.39-.39.39-1.03 0-1.41-.39-.39-1.03-.39-1.41 0l-1.06 1.06c-.39.39-.39 1.03 0 1.41s1.03.39 1.41 0l1.06-1.06zM7.05 18.36c.39-.39.39-1.03 0-1.41-.39-.39-1.03-.39-1.41 0l-1.06 1.06c-.39.39-.39 1.03 0 1.41s1.03.39 1.41 0l1.06-1.06z"/></svg>
        تم روشن (Light)
      </div>

      <div class="control-group">
        <span class="control-label">پس‌زمینه صفحه</span>
        <div class="control-input"><input type="color" id="--light-bg-color" data-var="--light-bg-color"></div>
      </div>
      <div class="control-group">
        <span class="control-label">متن اصلی</span>
        <div class="control-input"><input type="color" id="--light-text-color" data-var="--light-text-color"></div>
      </div>
      <div class="control-group">
        <span class="control-label">متن ثانویه (کم‌رنگ)</span>
        <div class="control-input"><input type="color" id="--light-text-color-light" data-var="--light-text-color-light"></div>
      </div>
      <div class="control-group">
        <span class="control-label">رنگ خطوط (Border)</span>
        <div class="control-input"><input type="color" id="--light-border-color" data-var="--light-border-color"></div>
      </div>
      <div class="control-group">
        <span class="control-label">پس‌زمینه تب‌بار</span>
        <div class="control-input"><input type="color" id="--light-tab-bar-bg" data-var="--light-tab-bar-bg"></div>
      </div>
      
      <div class="control-group">
        <span class="control-label">پس‌زمینه کارت‌ها</span>
        <div class="control-input"><input type="color" id="--light-card-bg-color" data-var="--light-card-bg-color"></div>
      </div>
      <div class="control-group">
        <span class="control-label">شفافیت کارت</span>
        <div class="control-input"><input type="range" id="--light-card-bg-opacity" data-var="--light-card-bg-opacity" min="0.1" max="1" step="0.05"></div>
      </div>
      <div class="control-group">
        <span class="control-label">بوردر کارت‌ها</span>
        <div class="control-input"><input type="text" id="--light-card-border" data-var="--light-card-border"></div>
      </div>
      <div class="control-group">
        <span class="control-label">سایه کارت‌ها</span>
        <div class="control-input"><input type="text" id="--light-card-shadow" data-var="--light-card-shadow"></div>
      </div>

      <div class="section-title">
        <svg viewBox="0 0 24 24"><path d="M12 3c-4.97 0-9 4.03-9 9s4.03 9 9 9 9-4.03 9-9c0-.46-.04-.92-.1-1.36-.98 1.37-2.58 2.26-4.4 2.26-3.03 0-5.5-2.47-5.5-5.5 0-1.82.89-3.42 2.26-4.4-.44-.06-.9-.1-1.36-.1z"/></svg>
        تم تاریک (Dark)
      </div>

      <div class="control-group">
        <span class="control-label">پس‌زمینه صفحه</span>
        <div class="control-input"><input type="color" id="--dark-bg-color" data-var="--dark-bg-color"></div>
      </div>
      <div class="control-group">
        <span class="control-label">متن اصلی</span>
        <div class="control-input"><input type="color" id="--dark-text-color" data-var="--dark-text-color"></div>
      </div>
      <div class="control-group">
        <span class="control-label">متن ثانویه</span>
        <div class="control-input"><input type="color" id="--dark-text-color-light" data-var="--dark-text-color-light"></div>
      </div>
      <div class="control-group">
        <span class="control-label">رنگ خطوط</span>
        <div class="control-input"><input type="color" id="--dark-border-color" data-var="--dark-border-color"></div>
      </div>
      <div class="control-group">
        <span class="control-label">پس‌زمینه تب‌بار</span>
        <div class="control-input"><input type="color" id="--dark-tab-bar-bg" data-var="--dark-tab-bar-bg"></div>
      </div>
      
      <div class="control-group">
        <span class="control-label">پس‌زمینه کارت‌ها</span>
        <div class="control-input"><input type="color" id="--dark-card-bg-color" data-var="--dark-card-bg-color"></div>
      </div>
      <div class="control-group">
        <span class="control-label">شفافیت کارت</span>
        <div class="control-input"><input type="range" id="--dark-card-bg-opacity" data-var="--dark-card-bg-opacity" min="0.1" max="1" step="0.05"></div>
      </div>
      <div class="control-group">
        <span class="control-label">بوردر کارت‌ها</span>
        <div class="control-input"><input type="text" id="--dark-card-border" data-var="--dark-card-border"></div>
      </div>
      <div class="control-group">
        <span class="control-label">سایه کارت‌ها</span>
        <div class="control-input"><input type="text" id="--dark-card-shadow" data-var="--dark-card-shadow"></div>
      </div>

    </div>
    
    <div class="sidebar-footer">
      <button class="btn btn-reset" onclick="resetTheme()">بازنشانی</button>
      <button class="btn btn-save" id="save-btn" onclick="saveTheme()">ذخیره تغییرات</button>
    </div>
  </div>

  <div class="preview-area">
    <div class="toast" id="status-toast">
      <span></span>
    </div>
    <div class="device-mockup">
      <div class="device-notch"></div>
      <iframe id="preview-frame" src="../menu.php?chat_id=<?php echo htmlspecialchars($admin_id); ?>"></iframe>
    </div>
  </div>

  <script>
    // دریافت متغیرهای فعلی از PHP
    const currentVars = <?php echo get_current_theme_vars(); ?>;
    let defaultVars = { ...currentVars }; 
    
    const iframe = document.getElementById('preview-frame');
    const saveBtn = document.getElementById('save-btn');
    const toast = document.getElementById('status-toast');

    // تبدیل Hex به RGB (برای متغیر --primary-color-rgb)
    function hexToRgb(hex) {
      var result = /^#?([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})$/i.exec(hex);
      return result ? 
        parseInt(result[1], 16) + ", " + parseInt(result[2], 16) + ", " + parseInt(result[3], 16)
        : null;
    }

    // نمایش پیام وضعیت
    function showToast(msg, type = 'success') {
      toast.querySelector('span').innerText = msg;
      toast.className = `toast show ${type}`;
      setTimeout(() => toast.classList.remove('show'), 3000);
    }

    document.addEventListener('DOMContentLoaded', () => {
      // پر کردن فیلدها با مقادیر فعلی
      document.querySelectorAll('.sidebar input[data-var]').forEach(input => {
        const varName = input.dataset.var;
        if (currentVars[varName]) {
          input.value = currentVars[varName];
          
          // آپدیت کردن تکست باکس کد رنگ برای Primary
          if(input.type === 'color' && varName === '--primary-color') {
             document.getElementById('hex-primary').value = currentVars[varName];
          }
        }
        
        // لیسنر برای تغییر زنده (Live Preview)
        input.addEventListener('input', (e) => {
          const val = e.target.value;
          updatePreview(varName, val);

          // اگر رنگ اصلی عوض شد، RGB آن هم آپدیت شود
          if (input.dataset.rgb) {
              const rgbVal = hexToRgb(val);
              if(rgbVal) {
                  updatePreview(input.dataset.rgb, rgbVal);
                  input.dataset.rgbValue = rgbVal; 
                  document.getElementById('hex-primary').value = val;
              }
          }
        });
      });
    });

    // اعمال تغییرات روی iframe
    function updatePreview(varName, value) {
      try {
        if (iframe.contentWindow) {
            iframe.contentWindow.document.documentElement.style.setProperty(varName, value);
        }
      } catch (e) { console.error(e); }
    }

    // بازنشانی به حالت ذخیره شده
    function resetTheme() {
      if (!confirm('آیا مطمئن هستید؟ تمام تغییرات ذخیره نشده از بین می‌رود.')) return;
      
      for (const key in defaultVars) {
        const input = document.querySelector(`input[data-var="${key}"]`);
        if (input) {
          input.value = defaultVars[key];
          updatePreview(key, defaultVars[key]);
          if(key === '--primary-color') {
             document.getElementById('hex-primary').value = defaultVars[key];
          }
        }
      }
      showToast('تنظیمات بازنشانی شد', 'success');
    }

    // ذخیره در فایل theme.css
    async function saveTheme() {
      saveBtn.disabled = true;
      saveBtn.innerText = 'در حال ذخیره...';

      const newVars = {};
      document.querySelectorAll('.sidebar input[data-var]').forEach(input => {
        newVars[input.dataset.var] = input.value;
        
        // اگر رنگ اصلی تغییر کرده، مقدار RGB جدید را بفرست
        if (input.dataset.rgb) {
           if (input.dataset.rgbValue) {
               newVars[input.dataset.rgb] = input.dataset.rgbValue;
           } else {
               newVars[input.dataset.rgb] = hexToRgb(input.value);
           }
        }
      });

      try {
        const response = await fetch('save_theme.php?admin_id=<?php echo htmlspecialchars($admin_id); ?>', {
          method: 'POST',
          headers: { 'Content-Type': 'application/json' },
          body: JSON.stringify(newVars)
        });
        const result = await response.json();

        if (result.status === 'ok') {
          showToast('✅ تغییرات با موفقیت ذخیره شد', 'success');
          defaultVars = { ...newVars }; // آپدیت مقادیر پیش‌فرض
          iframe.contentWindow.location.reload(); // رفرش فریم برای اطمینان
        } else {
          throw new Error(result.message);
        }

      } catch (error) {
        showToast('❌ خطا: ' + error.message, 'error');
      } finally {
        saveBtn.disabled = false;
        saveBtn.innerText = 'ذخیره تغییرات';
      }
    }
  </script>
</body>
</html>